-- when switching from Design Standard workspace, we want to restore the ribbon to default
-- if workspace we are switching to doesn't specify a ribbon.

-- in OnLoadScript.ms, we registered a callback to capture the name of the workspace we
-- are switching to into global variable _WorkspaceChangingTo

-- remove callback, no longer needed
callbacks.removeScripts id:#DesignStandardWorkspace
-- if global variable contains a string ...
if ((classof _WorkspaceChangingTo) == string) do
(
	-- get user ui directory
	local userUIDir = getdir #maxdata
	append userUIDir (substring (getdir #ui) ((getdir #maxroot).count+1) -1)
	-- get workspaces usersave directory
	local usersaveDir = userUIDir + @"Workspaces\usersave\"
	-- get the ribbon filename of the workspace we are switching to
	local ribbonFileName = _WorkspaceChangingTo+"__usersave__.ribbonconfig.ribbon"
	-- if the ribbon file does not exist ....
	if (not doesFileExist (usersaveDir + ribbonFileName)) do
	(
		MaxRibbon.ResetRibbon()
	)
)
_WorkspaceChangingTo = undefined -- clear global
